/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.AbstractReference2ShortMap;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.Reference2ShortMap;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.fastutil.shorts.ShortArraySet;
import it.unimi.dsi.fastutil.shorts.ShortArrays;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortCollections;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reference2ShortArrayMap<K>
extends AbstractReference2ShortMap<K> {
    private static final long serialVersionUID = 1L;
    private K[] key;
    private short[] value;
    private int size;

    public Reference2ShortArrayMap(K[] key, short[] value) {
        this.key = key;
        this.value = value;
        if (key.length != value.length) {
            throw new IllegalArgumentException("Keys and values have different lengths (" + key.length + ", " + value.length + ")");
        }
    }

    public Reference2ShortArrayMap(Class<K> keyClass) {
        this.key = (Object[])Array.newInstance(keyClass, 0);
        this.value = ShortArrays.EMPTY_ARRAY;
    }

    @Override
    public ObjectSet<Map.Entry<K, Short>> entrySet() {
        return new AbstractObjectSet<Map.Entry<K, Short>>(){

            @Override
            public ObjectIterator<Map.Entry<K, Short>> iterator() {
                return new AbstractObjectIterator<Map.Entry<K, Short>>(){
                    int next = 0;

                    @Override
                    public boolean hasNext() {
                        return this.next < Reference2ShortArrayMap.this.size;
                    }

                    @Override
                    public Map.Entry<K, Short> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return new AbstractReference2ShortMap.BasicEntry<Object>(Reference2ShortArrayMap.this.key[this.next], Reference2ShortArrayMap.this.value[this.next++]);
                    }
                };
            }

            @Override
            public int size() {
                return Reference2ShortArrayMap.this.size;
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Reference2ShortMap.Entry e = (Reference2ShortMap.Entry)o;
                return Reference2ShortArrayMap.this.containsKey(e.getKey()) && Reference2ShortArrayMap.this.get(e.getKey()) == e.getValue();
            }
        };
    }

    private int findKey(Object k) {
        K[] key = this.key;
        int i = this.size;
        while (i-- != 0) {
            if (key[i] != k) continue;
            return i;
        }
        return -1;
    }

    @Override
    public short getShort(Object k) {
        K[] key = this.key;
        int i = this.size;
        while (i-- != 0) {
            if (key[i] != k) continue;
            return this.value[i];
        }
        return this.defRetValue;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        int i = this.size;
        while (i-- != 0) {
            this.key[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean containsKey(Object k) {
        return this.findKey(k) != -1;
    }

    @Override
    public boolean containsValue(short v) {
        int i = this.size;
        while (i-- != 0) {
            if (this.value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public short put(K k, short v) {
        int oldKey = this.findKey(k);
        if (oldKey != -1) {
            short oldValue = this.value[oldKey];
            this.value[oldKey] = v;
            return oldValue;
        }
        if (this.size == this.key.length) {
            this.key = ObjectArrays.grow(this.key, this.size + 1);
            this.value = ShortArrays.grow(this.value, this.size + 1);
        }
        this.key[this.size] = k;
        this.value[this.size] = v;
        ++this.size;
        return this.defRetValue;
    }

    @Override
    public short removeShort(Object k) {
        int oldPos = this.findKey(k);
        if (oldPos == -1) {
            return this.defRetValue;
        }
        short oldValue = this.value[oldPos];
        System.arraycopy(this.key, oldPos + 1, this.key, oldPos, this.size - oldPos - 1);
        System.arraycopy(this.value, oldPos + 1, this.value, oldPos, this.size - oldPos - 1);
        --this.size;
        this.key[this.size] = null;
        return oldValue;
    }

    @Override
    public ReferenceSet<K> keySet() {
        return new ReferenceArraySet<K>(this.key, this.size);
    }

    @Override
    public ShortCollection values() {
        return ShortCollections.unmodifiable(new ShortArraySet(this.value, this.size));
    }
}

