/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.floats.AbstractFloatCollection;
import it.unimi.dsi.fastutil.floats.AbstractFloatIterator;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.shorts.AbstractShortIterator;
import it.unimi.dsi.fastutil.shorts.AbstractShortSet;
import it.unimi.dsi.fastutil.shorts.Short2FloatMap;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractShort2FloatMap
implements Short2FloatMap,
Serializable {
    protected float defRetValue;

    protected AbstractShort2FloatMap() {
    }

    @Override
    public void defaultReturnValue(float rv) {
        this.defRetValue = rv;
    }

    @Override
    public float defaultReturnValue() {
        return this.defRetValue;
    }

    @Override
    public float put(short key, float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float remove(short key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Float get(Object ok) {
        short k = (Short)ok;
        return this.containsKey(k) ? Float.valueOf(this.get(k)) : null;
    }

    @Override
    public Float put(Short ok, Float ov) {
        short k = ok;
        float v = this.put(k, ov.floatValue());
        return this.containsKey(k) ? Float.valueOf(v) : null;
    }

    @Override
    public Float remove(Object ok) {
        short k = (Short)ok;
        float v = this.remove(k);
        return this.containsKey(k) ? Float.valueOf(v) : null;
    }

    @Override
    public boolean containsValue(Object ov) {
        return this.containsValue(((Float)ov).floatValue());
    }

    @Override
    public boolean containsKey(Object ok) {
        return this.containsKey((Short)ok);
    }

    @Override
    public boolean containsValue(float v) {
        return this.values().contains(v);
    }

    @Override
    public boolean containsKey(short k) {
        return this.keySet().contains(k);
    }

    @Override
    public void putAll(Map<? extends Short, ? extends Float> m) {
        int n = m.size();
        Iterator<Map.Entry<? extends Short, ? extends Float>> i = m.entrySet().iterator();
        if (m instanceof Short2FloatMap) {
            while (n-- != 0) {
                Short2FloatMap.Entry e = (Short2FloatMap.Entry)i.next();
                this.put(e.getShortKey(), e.getFloatValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry<? extends Short, ? extends Float> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ShortSet keySet() {
        return new AbstractShortSet(){

            public boolean contains(short k) {
                return AbstractShort2FloatMap.this.containsKey(k);
            }

            public int size() {
                return AbstractShort2FloatMap.this.size();
            }

            public void clear() {
                AbstractShort2FloatMap.this.clear();
            }

            public ShortIterator iterator() {
                return new AbstractShortIterator(){
                    final ObjectIterator<Map.Entry<Short, Float>> i;
                    {
                        this.i = AbstractShort2FloatMap.this.entrySet().iterator();
                    }

                    public short nextShort() {
                        return ((Short2FloatMap.Entry)this.i.next()).getShortKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public FloatCollection values() {
        return new AbstractFloatCollection(){

            public boolean contains(float k) {
                return AbstractShort2FloatMap.this.containsValue(k);
            }

            public int size() {
                return AbstractShort2FloatMap.this.size();
            }

            public void clear() {
                AbstractShort2FloatMap.this.clear();
            }

            public FloatIterator iterator() {
                return new AbstractFloatIterator(){
                    final ObjectIterator<Map.Entry<Short, Float>> i;
                    {
                        this.i = AbstractShort2FloatMap.this.entrySet().iterator();
                    }

                    public float nextFloat() {
                        return ((Short2FloatMap.Entry)this.i.next()).getFloatValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public int hashCode() {
        int h = 0;
        int n = this.size();
        ObjectIterator<Map.Entry<Short, Float>> i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)((Map.Entry)i.next())).hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        ObjectIterator<Map.Entry<Short, Float>> i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Short2FloatMap.Entry e = (Short2FloatMap.Entry)i.next();
            s.append(String.valueOf(e.getShortKey()));
            s.append("=>");
            s.append(String.valueOf(e.getFloatValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Short2FloatMap.Entry {
        protected short key;
        protected float value;

        public BasicEntry(Short key, Float value) {
            this.key = key;
            this.value = value.floatValue();
        }

        public BasicEntry(short key, float value) {
            this.key = key;
            this.value = value;
        }

        public Short getKey() {
            return this.key;
        }

        public short getShortKey() {
            return this.key;
        }

        public Float getValue() {
            return Float.valueOf(this.value);
        }

        public float getFloatValue() {
            return this.value;
        }

        public float setValue(float value) {
            throw new UnsupportedOperationException();
        }

        public Float setValue(Float value) {
            return Float.valueOf(this.setValue(value.floatValue()));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Short)e.getKey() && this.value == ((Float)e.getValue()).floatValue();
        }

        public int hashCode() {
            return this.key ^ HashCommon.float2int(this.value);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

