/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class FileSystemUtils {
    private static final FileSystemUtils INSTANCE = new FileSystemUtils();
    private static final int INIT_PROBLEM = -1;
    private static final int OTHER = 0;
    private static final int WINDOWS = 1;
    private static final int UNIX = 2;
    private static final int POSIX_UNIX = 3;
    private static final int OS;

    static {
        int os = 0;
        try {
            String osName = System.getProperty("os.name");
            if (osName == null) {
                throw new IOException("os.name not found");
            }
            os = (osName = osName.toLowerCase()).indexOf("windows") != -1 ? 1 : (osName.indexOf("linux") != -1 || osName.indexOf("sun os") != -1 || osName.indexOf("sunos") != -1 || osName.indexOf("solaris") != -1 || osName.indexOf("mpe/ix") != -1 || osName.indexOf("freebsd") != -1 || osName.indexOf("irix") != -1 || osName.indexOf("digital unix") != -1 || osName.indexOf("unix") != -1 || osName.indexOf("mac os x") != -1 ? 2 : (osName.indexOf("hp-ux") != -1 || osName.indexOf("aix") != -1 ? 3 : 0));
        }
        catch (Exception exception) {
            os = -1;
        }
        OS = os;
    }

    public static long freeSpace(String path) throws IOException {
        return INSTANCE.freeSpaceOS(path, OS, false);
    }

    public static long freeSpaceKb(String path) throws IOException {
        return INSTANCE.freeSpaceOS(path, OS, true);
    }

    long freeSpaceOS(String path, int os, boolean kb) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("Path must not be empty");
        }
        switch (os) {
            case 1: {
                return kb ? this.freeSpaceWindows(path) / 1024L : this.freeSpaceWindows(path);
            }
            case 2: {
                return this.freeSpaceUnix(path, kb, false);
            }
            case 3: {
                return this.freeSpaceUnix(path, kb, true);
            }
            case 0: {
                throw new IllegalStateException("Unsupported operating system");
            }
        }
        throw new IllegalStateException("Exception caught when determining operating system");
    }

    long freeSpaceWindows(String path) throws IOException {
        if ((path = FilenameUtils.normalize(path)).length() > 2 && path.charAt(1) == ':') {
            path = path.substring(0, 2);
        }
        String[] cmdAttribs = new String[]{"cmd.exe", "/C", "dir /-c " + path};
        List lines = this.performCommand(cmdAttribs, Integer.MAX_VALUE);
        int i = lines.size() - 1;
        while (i >= 0) {
            String line = (String)lines.get(i);
            if (line.length() > 0) {
                return this.parseDir(line, path);
            }
            --i;
        }
        throw new IOException("Command line 'dir /-c' did not return any info for path '" + path + "'");
    }

    long parseDir(String line, String path) throws IOException {
        char c;
        int bytesStart = 0;
        int bytesEnd = 0;
        int j = line.length() - 1;
        while (j >= 0) {
            c = line.charAt(j);
            if (Character.isDigit(c)) {
                bytesEnd = j + 1;
                break;
            }
            --j;
        }
        while (j >= 0) {
            c = line.charAt(j);
            if (!Character.isDigit(c) && c != ',' && c != '.') {
                bytesStart = j + 1;
                break;
            }
            --j;
        }
        if (j < 0) {
            throw new IOException("Command line 'dir /-c' did not return valid info for path '" + path + "'");
        }
        StringBuffer buf = new StringBuffer(line.substring(bytesStart, bytesEnd));
        int k = 0;
        while (k < buf.length()) {
            if (buf.charAt(k) == ',' || buf.charAt(k) == '.') {
                buf.deleteCharAt(k--);
            }
            ++k;
        }
        return this.parseBytes(buf.toString(), path);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long freeSpaceUnix(String path, boolean kb, boolean posix) throws IOException {
        String[] stringArray;
        if (path.length() == 0) {
            throw new IllegalArgumentException("Path must not be empty");
        }
        path = FilenameUtils.normalize(path);
        String flags = "-";
        if (kb) {
            flags = String.valueOf(flags) + "k";
        }
        if (posix) {
            flags = String.valueOf(flags) + "P";
        }
        if (flags.length() > 1) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "df";
            stringArray2[1] = flags;
            stringArray = stringArray2;
            stringArray2[2] = path;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "df";
            stringArray = stringArray3;
            stringArray3[1] = path;
        }
        String[] cmdAttribs = stringArray;
        List lines = this.performCommand(cmdAttribs, 3);
        if (lines.size() < 2) {
            throw new IOException("Command line 'df' did not return info as expected for path '" + path + "'- response was " + lines);
        }
        String line2 = (String)lines.get(1);
        StringTokenizer tok = new StringTokenizer(line2, " ");
        if (tok.countTokens() < 4) {
            if (tok.countTokens() != 1 || lines.size() < 3) throw new IOException("Command line 'df' did not return data as expected for path '" + path + "'- check path is valid");
            String line3 = (String)lines.get(2);
            tok = new StringTokenizer(line3, " ");
        } else {
            tok.nextToken();
        }
        tok.nextToken();
        tok.nextToken();
        String freeSpace = tok.nextToken();
        return this.parseBytes(freeSpace, path);
    }

    long parseBytes(String freeSpace, String path) throws IOException {
        try {
            long bytes = Long.parseLong(freeSpace);
            if (bytes < 0L) {
                throw new IOException("Command line 'df' did not find free space in response for path '" + path + "'- check path is valid");
            }
            return bytes;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Command line 'df' did not return numeric data as expected for path '" + path + "'- check path is valid");
        }
    }

    List performCommand(String[] cmdAttribs, int max) throws IOException {
        ArrayList<String> arrayList;
        ArrayList<String> lines = new ArrayList<String>(20);
        Process proc = null;
        InputStream in = null;
        OutputStream out = null;
        InputStream err = null;
        BufferedReader inr = null;
        try {
            proc = this.openProcess(cmdAttribs);
            in = proc.getInputStream();
            out = proc.getOutputStream();
            err = proc.getErrorStream();
            inr = new BufferedReader(new InputStreamReader(in));
            String line = inr.readLine();
            while (line != null && lines.size() < max) {
                line = line.toLowerCase().trim();
                lines.add(line);
                line = inr.readLine();
            }
            proc.waitFor();
            if (proc.exitValue() != 0) {
                throw new IOException("Command line returned OS error code '" + proc.exitValue() + "' for command " + Arrays.asList(cmdAttribs));
            }
            if (lines.size() == 0) {
                throw new IOException("Command line did not return any info for command " + Arrays.asList(cmdAttribs));
            }
            arrayList = lines;
            Object var10_12 = null;
        }
        catch (InterruptedException ex) {
            try {
                throw new IOException("Command line threw an InterruptedException '" + ex.getMessage() + "' for command " + Arrays.asList(cmdAttribs));
            }
            catch (Throwable throwable) {
                block8: {
                    Object var10_13 = null;
                    IOUtils.closeQuietly(in);
                    IOUtils.closeQuietly(out);
                    IOUtils.closeQuietly(err);
                    IOUtils.closeQuietly(inr);
                    if (proc == null) break block8;
                    proc.destroy();
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly(in);
        IOUtils.closeQuietly(out);
        IOUtils.closeQuietly(err);
        IOUtils.closeQuietly(inr);
        if (proc != null) {
            proc.destroy();
        }
        return arrayList;
    }

    Process openProcess(String[] cmdAttribs) throws IOException {
        return Runtime.getRuntime().exec(cmdAttribs);
    }
}

